#if !defined(FCM_H)
#define FCM_H

#if defined(__cplusplus)
extern "C" {
#endif

#include "cb.h"

#if defined(__cplusplus)
}
#endif


#include "fuzzy.hpp"
#include "DistCrit/criteria.h"

#if defined(__cplusplus)
extern "C" {
#endif

/* Returns results in CB & PA, they must have been created. They are
   initialized from random solution. */
int RandomizedFuzzyCMeans(
    TRAININGSET* TS, CODEBOOK* CB, FuzzyPartitioning* FPA,
    CriterionInfo* CI, float* FinalError, int Solutions, int FCMIterations,
    int Output, int Trace, int TraceID);

/* Returns results in CB & FPA, they must have been created. */
int FuzzyCMeans(TRAININGSET* TS, CODEBOOK* CB, FuzzyPartitioning* FPA,
    int GLAIterations, CriterionInfo* CI);

int EmbeddedFCM(TRAININGSET* TS, CODEBOOK* CB, FuzzyPartitioning* FPA,
    int FCMIterations, CriterionInfo* CI);

/* Functions below are same as the ones above, but they perform crisp-fuzzy
   conversions internally. Essentially convenience functions. */

/* FinishWithGLA should be -1 if GLA not used, 0 for iterations until
 * convergence and otherwise the maximum number of iterations.
 */
int CrispRandomizedFuzzyCMeans(
    TRAININGSET* TS, CODEBOOK* CB, PARTITIONING* PA,
    CriterionInfo* CI, float* FinalError, int Solutions, int FCMIterations,
    int FinishWithGLA, int Output, int Trace, int TraceID);

int CrispFuzzyCMeans(TRAININGSET* TS, CODEBOOK* CB, PARTITIONING* PA,
    int FCMIterations, CriterionInfo* CI, int FinishWithGLA);

int CrispEmbeddedFCM(TRAININGSET* TS, CODEBOOK* CB, PARTITIONING* PA,
    int FCMIterations, CriterionInfo* CI);

#if defined(__cplusplus)
}
#endif

#endif

