/*-------------------------------------------------------------------

    GLA.C

    9.10.2002

    Ismo Krkkinen

    GLA and RGLA.

-------------------------------------------------------------------*/

#define VersionNumber "v0.1.1"

#include <float.h>
#include <stdio.h>
#include <time.h>

#include "gla.h"
#include "cb.h"
#include "interfc.h"
#include "memctrl.h"
#include <string.h>
#include "cb_util.h"
#include "DistCrit/criteria.h"
#include "DistCrit/distance.h"


static void PrintOutput(int Iter, float Error, float Best, int Improved,
    int Output)
{
    switch (Output) {
    case 0: break;
    case 1:
        if (Improved) PrintMessage("%i\t%#.6g\n", Iter, Best);
        break;
    default:
        PrintMessage("%i\t%#9.6g\t%#.6g\n", Iter, Best, Error);
        break;
    }
}

static void PrintTrace(int Print, int ID, int Groups, int Iter, float Error)
{
    if (Print) ErrorMessage("%i\t%i\t%i\t%e\n", ID, Groups, Iter, Error);
}

int RandomizedGeneralizedLloydAlgorithm(
    TRAININGSET* TS, CODEBOOK* CB, PARTITIONING* PA,
    CriterionInfo* CI, float* FinalError, int Solutions, int GLAIterations,
    int Output, int Trace, int TraceID)
{
    CODEBOOK CBnew;
    PARTITIONING PAnew;
    int k, Improved, Sum;
    float Value;
    if (!strstr(CB->GenerationMethod, "RGLA ")) {
        if (*(CB->GenerationMethod)) AddGenerationMethod(CB, " + ");
        AddGenerationMethod(CB, "RGLA ");
        AddGenerationMethod(CB, VersionNumber);
    }
    if (BookSize(TS) == BookSize(CB)) {
        PutAllInOwnPartition(TS, PA);
        GenerateOptimalCodebookGeneral(TS, CB, PA, MSE);
        return 0;
    }
    CreateNewCodebook(&CBnew, BookSize(CB), TS);
    CreateNewPartitioning(&PAnew, TS, BookSize(CB));
    *FinalError = 1e30;
    Sum = 0;
    for (k = 0; k < Solutions; ++k) {
        GenerateRandomCodebook(TS, &CBnew);
        Sum += GeneralizedLloydAlgorithm(TS, &CBnew, &PAnew, GLAIterations, CI);
        Value = ciEvaluate(CI, &CBnew, &PAnew);
        Improved = *FinalError > Value;
        if (Improved) {
            CopyCodebook(&CBnew, CB);
            CopyPartitioning(&PAnew, PA);
            *FinalError = Value;
            PrintTrace(Trace, TraceID, BookSize(CB), Sum, *FinalError);
        }
        if (Output) PrintOutput(k, Value, *FinalError, Improved, Output);
    }
    PrintTrace(Trace, TraceID, BookSize(CB), Sum, *FinalError);
    FreeCodebook(&CBnew);
    FreePartitioning(&PAnew);
    return Sum;
}

int GeneralizedLloydAlgorithm(TRAININGSET* TS, CODEBOOK* CB, PARTITIONING* PA,
    int GLAIterations, CriterionInfo* CI)
{
    int *Changes;
    if (!strstr(CB->GenerationMethod, "GLA ")) {
        if (*(CB->GenerationMethod)) AddGenerationMethod(CB, " + ");
        AddGenerationMethod(CB, "GLA ");
        AddGenerationMethod(CB, VersionNumber);
    }
    if (BookSize(TS) == BookSize(CB)) {
        PutAllInOwnPartition(TS, PA);
        GenerateOptimalCodebookGeneral(TS, CB, PA, MSE);
        return 0;
    }
    Changes = allocate(sizeof(int) * BookSize(CB));
    memset(Changes, 1, sizeof(int) * BookSize(CB));
    GLAIterations = EmbeddedGLA(TS, CB, PA, GLAIterations, CI, Changes);
    deallocate(Changes);
    return GLAIterations;
}

int EmbeddedGLA(TRAININGSET* TS, CODEBOOK* CB, PARTITIONING* PA,
    int GLAIterations, CriterionInfo* CI, int* Changes)
{
    int k;
    if (!GLAIterations) GLAIterations = -1;
    for (k = 0; k != GLAIterations; ++k) {
        ciPartitionOptimally(CI, CB, PA, Changes);
        if (!ciCalculateOptimalCentroids(CI, CB, PA, Changes)) break;
    }
    return k;
}

