#ifndef GLA_H
#define GLA_H

#include "cb.h"
#include "DistCrit/criteria.h"

#if defined(__cplusplus)
extern "C" {
#endif

/* Returns results in CB & PA, they must have been created. They are
   initialized from random solution. */
int RandomizedGeneralizedLloydAlgorithm(
    TRAININGSET* TS, CODEBOOK* CB, PARTITIONING* PA,
    CriterionInfo* CI, float* FinalError, int Solutions, int GLAIterations,
    int Output, int Trace, int TraceID);

/* Returns results in CB & PA, they must have been created. */
int GeneralizedLloydAlgorithm(TRAININGSET* TS, CODEBOOK* CB, PARTITIONING* PA,
    int GLAIterations, CriterionInfo* CI);

int EmbeddedGLA(TRAININGSET* TS, CODEBOOK* CB, PARTITIONING* PA,
    int GLAIterations, CriterionInfo* CI, int* Changes);

#if defined(__cplusplus)
}
#endif

#endif

