/*-------------------------------------------------------------------

    LBGU.C

    19.12.2001

    Ismo Krkkinen

    LBGU.

-------------------------------------------------------------------*/

#define VersionNumber "v0.1.0"

#include <float.h>
#include <stdio.h>
#include <time.h>

#include "gla.h"
#include "lbgu.h"
#include "cb.h"
#include "interfc.h"
#include "memctrl.h"
#include <string.h>
#include "cb_util.h"
#include "DistCrit/distance.h"
#include "random.h"

static void MoveCentroid(TRAININGSET* TS, CODEBOOK* CB, PARTITIONING* PA,
    DistanceInfo* DI)
{
    int k, m, Vect;
    float MaxError, MinError, Error, MyDist, Dist, MinDist;
    int MinIndex, MaxIndex;
    MinError = 1e30;
    MaxError = 0;
    MinIndex = MaxIndex = 0;
    for (k = 0; k < BookSize(CB); ++k) {
        Error = 0;
        Vect = FirstVector(PA, k);
        while (!EndOfPartition(Vect)) {
            MyDist = diDistance(DI, TS, CB, PA, Vect, k, DT_DATA2MODEL);
            if (k)
                MinDist = diDistance(DI, TS, CB, PA, Vect, 0, DT_DATA2MODEL);
            else MinDist = diDistance(DI, TS, CB, PA, Vect, 1, DT_DATA2MODEL);
            for (m = 1; m < BookSize(CB); ++m) if (m != k) {
                Dist = diDistance(DI, TS, CB, PA, Vect, m, DT_DATA2MODEL);
                if (Dist < MinDist) MinDist = Dist;
            }
            Error +=
                VectorFreq(TS, Vect) * (MinDist - MyDist) / CCFreq(PA, k);
            Vect = NextVector(PA, Vect);
        }
        if (Error < MinError) {
            MinError = Error;
            MinIndex = k;
        } else if (Error > MaxError) {
            MaxError = Error;
            MaxIndex = k;
        }
    }
    Vect = FirstVector(PA, MaxIndex);
    if (UniqueVectors(PA, MaxIndex) > 1)
        for (m = 0; m < irand(0, UniqueVectors(PA, MaxIndex) - 1); ++m)
            Vect = NextVector(PA, Vect);
    /*if (Vect == -1) Vect = FirstVector(PA, MaxIndex);*/
    if (EqualVectors(Vector(CB, MinIndex), Vector(TS, Vect), VectorSize(CB))) {
        if (Vect == FirstVector(PA, MaxIndex)) Vect = NextVector(PA, Vect);
        else Vect = FirstVector(PA, MaxIndex);
    }
    CopyVector(Vector(TS, Vect), Vector(CB, MinIndex), VectorSize(CB));
}

static void PrintOutput(int Iter, float Error, float Best, int Improved,
    int Output)
{
    switch (Output) {
    case 0: break;
    case 1:
	if (Improved) PrintMessage("%i\t%#.6g\n", Iter, Best);
	break;
    default:
	PrintMessage("%i\t%#9.6g\t%#.6g\n", Iter, Best, Error);
	break;
    }
}

static void PrintTrace(int Print, int ID, int Groups, int Iter, float Error)
{
    if (Print) ErrorMessage("%i\t%i\t%i\t%e\n", ID, Groups, Iter, Error);
}

int LBGU(TRAININGSET* TS, CODEBOOK* CB, PARTITIONING* PA,
    CriterionInfo* CI, float* FinalError, int Output, int Trace, int TraceID)
{
    CODEBOOK CBnew;
    PARTITIONING PAnew;
    int IterationNumber, Iterations, Improved;
    float Value;
    if (!strstr(CB->GenerationMethod, "LBGU ")) {
	if (*(CB->GenerationMethod)) AddGenerationMethod(CB, " + ");
	AddGenerationMethod(CB, "LBGU ");
	AddGenerationMethod(CB, VersionNumber);
    }
    if (BookSize(TS) == BookSize(CB)) {
	PutAllInOwnPartition(TS, PA);
	GenerateOptimalCodebookGeneral(TS, CB, PA, MSE);
	return 0;
    }
    Iterations = GeneralizedLloydAlgorithm(TS, CB, PA, 200, CI);
    CreateNewCodebook(&CBnew, BookSize(CB), TS);
    CreateNewPartitioning(&PAnew, TS, BookSize(CB));
    IterationNumber = 0;
    *FinalError = ciEvaluate(CI, CB, PA);
    PrintTrace(Trace, TraceID, BookSize(CB), IterationNumber, *FinalError);
    do {
        ++IterationNumber;
        /* get least useful centroid and swap it */
        CopyCodebook(CB, &CBnew);
        CopyPartitioning(PA, &PAnew);
        MoveCentroid(TS, &CBnew, &PAnew, ciCriterionDistance(CI));
        Iterations += GeneralizedLloydAlgorithm(TS, &CBnew, &PAnew, 200, CI);
	Value = ciEvaluate(CI, &CBnew, &PAnew);
	Improved = *FinalError > Value;
	if (Improved) {
	    CopyCodebook(&CBnew, CB);
	    CopyPartitioning(&PAnew, PA);
	    *FinalError = Value;
	    PrintTrace(Trace, TraceID, BookSize(CB), Iterations,
	        *FinalError);
	}
	if (Output) PrintOutput(IterationNumber, Value, *FinalError,
	    Improved, Output);
    } while (Improved);
    FreeCodebook(&CBnew);
    FreePartitioning(&PAnew);
    return Iterations;
}

int RandomizedLBGU(TRAININGSET* TS, CODEBOOK* CB, PARTITIONING* PA,
    CriterionInfo* CI, float* FinalError, int Solutions,
    int Output, int Trace, int TraceID)
{
    CODEBOOK CBnew;
    PARTITIONING PAnew;
    int k, Improved, Sum;
    float Value;
    if (!strstr(CB->GenerationMethod, "RLBGU ")) {
        if (*(CB->GenerationMethod)) AddGenerationMethod(CB, " + ");
        AddGenerationMethod(CB, "RLBGU ");
        AddGenerationMethod(CB, VersionNumber);
    }
    if (BookSize(TS) == BookSize(CB)) {
        PutAllInOwnPartition(TS, PA);
        GenerateOptimalCodebookGeneral(TS, CB, PA, MSE);
        return 0;
    }
    CreateNewCodebook(&CBnew, BookSize(CB), TS);
    CreateNewPartitioning(&PAnew, TS, BookSize(CB));
    *FinalError = 1e30;
    Sum = 0;
    for (k = 0; k < Solutions; ++k) {
        GenerateRandomCodebook(TS, &CBnew);
        Sum += LBGU(TS, &CBnew, &PAnew, CI, &Value, 0, 0, 0);
        Improved = *FinalError > Value;
        if (Improved) {
            CopyCodebook(&CBnew, CB);
            CopyPartitioning(&PAnew, PA);
            *FinalError = Value;
            PrintTrace(Trace, TraceID, BookSize(CB), Sum, *FinalError);
        }
        if (Output) PrintOutput(k, Value, *FinalError, Improved, Output);
    }
    PrintTrace(Trace, TraceID, BookSize(CB), Sum, *FinalError);
    FreeCodebook(&CBnew);
    FreePartitioning(&PAnew);
    return Sum;
}

